'use strict';
(function (angular, window, jaw_variables, undefined) {

    // path to templates
    // musi to tu byt jinak relativni cesta vychazi z URL v prohlížeči 
    // NAPR: /wp-admin/elements-templates/... namisto ../wp-content/themes/gdaynews/framework/admin/assets/elements-templates/
    var scripts = document.getElementsByTagName("script");
    var currentScriptPath = scripts[scripts.length - 1].src;
    currentScriptPath = currentScriptPath.substring(0, currentScriptPath.lastIndexOf('/'));
    var currentPath = currentScriptPath.substring(0, currentScriptPath.lastIndexOf('/') + 1);
    var templateFolder = 'elements-templates';

    var directives = angular.module('jwDirectives', ['jwServices', 'jwFileters']);

    /**
    * @name         jwdTypografy
    * @description  font manager 
    *
    * @todo         bude potrebovat refaktoring
    */
    directives.directive('jwdTypografy', [
        '$compile',
        '$timeout',
        'jwsJson',
        'jwsUtils',
        'jwsContextMenu',
        function ($compile, $timeout, jwsJson, jwsUtils, jwsContextMenu) {
            return {
                restrict: 'E',
                scope: {
                    typografy: '=',
                    managermod: '='
                },
                template: '<div ng-include="getTemplateUrl()"></div>',
                link: function (scope, element, attrs, ngModel) {

                    // INIT *******************************************
                    scope.sortableOptions = {
                        'ui-floating': true,
                        placeholder: "ui-typografy-place-sortable-placeholder",
                        connectWith: ".jw-typografy-font-places",
                        start: function (e, ui) {
                            angular.element('.jw-typografy-font-places').addClass('jw-drag');
                        },
                        stop: function (e, ui) {
                            angular.element('.jw-typografy-font-places').removeClass('jw-drag');
                        }
                    };

                    scope.sortableTypografyOptions = {
                        'ui-floating': true,
                        placeholder: "ui-typografy-sortable-placeholder",
                        delay: 200
                    };
                    scope.url = jaw_variables['JAW_THEME_URI'] + '/help/images/';

                    scope.opt = {};

                    scope.styles = {};

                    //source
                    scope.opt.source = {
                        'none': 'Self-hosted font (upload woff)',
                        'google': 'Google Fonts'
                    }

                    //WEIGHT
                    scope.opt.weight = {
                        '100': '100',
                        '100italic': '100 italic',
                        '200': '200',
                        '200italic': '200 italic',
                        '300': '300',
                        '300italic': '300 italic',
                        '400': '400',
                        '400italic': '400 italic',
                        '500': '500',
                        '500italic': '500 italic',
                        '600': '600',
                        '600italic': '600 italic',
                        '700': '700',
                        '700italic': '700 italic',
                        '800': '800',
                        '800italic': '800 italic',
                        '900': '900',
                        '900italic': '900 italic',
                    };

                    //SIZE
                    scope.opt.size = {};
                    for (var i = 9; i <= 40; i++) {
                        scope.opt.size[i + 'px'] = i + 'px';
                    }

                    //LINE HEIGHT
                    scope.opt.lineHeight = {
                        '1em': '1em',
                        '1.1em': '1.1em',
                        '1.2em': '1.2em',
                        '1.3em': '1.3em',
                        '1.4em': '1.4em',
                        '1.5em': '1.5em',
                        '1.6em': '1.6em',
                        '1.7em': '1.7em',
                        '1.8em': '1.8em',
                        '1.9em': '1.9em',
                        '2em': '2em',
                        '2.5em': '2.5em',
                        '3em': '3em',
                    };
                    for (var i = 9; i <= 60; i++) {
                        scope.opt.lineHeight[i + 'px'] = i + 'px';
                    }

                    //websafe
                    scope.opt.websafe = {
                        'serif': 'serif',
                        'sans-serif': 'sans-serif',
                        'monospace': 'monospace'
                    }


                    var styleModel = {
                        'id': jwsUtils.getUniqueId(),
                        'family': 'PT Sans',
                        'name': 'Click and Name it here',
                        'source': 'google',
                        'weight': '300',
                        'size': '16px',
                        'lineHeight': '1.5em',
                        'websafe': 'serif',
                        'places': []
                    }

                    // uvodni initializace
                    $timeout(function () {
                        scope.$apply(function () {
                            scope.checkList(scope.typografy);
                        });
                    });


                    scope.checkList = function (data) {
                        var places = [];
                        angular.forEach(data, function (value, id) {
                            angular.forEach(value.places, function (place, i) {
                                if (scope.allPlaces[place] !== undefined) {
                                    places[place] = 'ok';
                                }
                            });
                        });
                        angular.forEach(scope.allPlaces, function (place, i) {
                            if (places[i] === undefined && data !== null && data[0] !== undefined) {
                                data[0].places.push(i);
                            }
                        });
                    }

                    scope.getTypografyPlace = function (place) {
                        return scope.allPlaces[place];
                    }

                    // Prepinani modu
                    scope.$watch('managermod', function (newValue, oldValue) {
                        scope.transfer(newValue);
                        scope.transfer(newValue);//hotFix
                    });

                    scope.$watch('styles', function (newValue, oldValue) {
                        scope.transfer('advanced');
                        scope.transfer('advanced');//hotFix
                    }, true);

                    scope.transfer = function (to) {
                        switch (to) {
                            case 'classical':
                                angular.forEach(scope.allPlaces, function (place, key) {
                                    angular.forEach(scope.typografy, function (typo, k) {
                                        if (typo.places.indexOf(key) !== -1) {
                                            scope.styles[key] = angular.copy(typo);
                                        }
                                    });
                                });
                                break;
                            case 'advanced':
                                if (Object.keys(scope.styles).length) {
                                    angular.forEach(scope.typografy, function (typo, k) {
                                        typo.places = [];
                                        angular.forEach(scope.styles, function (style, key) {
                                            if (style.family === typo.family &&
                                                style.source === typo.source &&
                                                style.weight === typo.weight &&
                                                style.size === typo.size &&
                                                style.lineHeight === typo.lineHeight &&
                                                style.websafe === typo.websafe &&
                                                style.inserted === undefined) {
                                                typo.places.push(key);
                                                style.inserted = true;
                                            }
                                        });
                                        //prazdny sekce vymazu
                                        if (typo.places.length == 0) {
                                            scope.typografy.splice(k, 1);
                                        }
                                    });
                                    // pokud se neda seskupit s nicim jinym - vytvorim novou sekci
                                    angular.forEach(scope.styles, function (style, key) {
                                        if (style.inserted === undefined) {
                                            scope.addNewItem();
                                            scope.typografy[scope.typografy.length - 1].name = 'Click and Name it here';
                                            scope.typografy[scope.typografy.length - 1].family = style.family;
                                            scope.typografy[scope.typografy.length - 1].source = style.source;
                                            scope.typografy[scope.typografy.length - 1].weight = style.weight;
                                            scope.typografy[scope.typografy.length - 1].size = style.size;
                                            scope.typografy[scope.typografy.length - 1].lineHeight = style.lineHeight;
                                            scope.typografy[scope.typografy.length - 1].websafe = style.websafe;
                                            scope.typografy[scope.typografy.length - 1].places.push(key);
                                        }
                                        style.inserted = undefined;
                                    });
                                }
                                break;
                        }
                    }

                    // dynamicka zmena sablony direktivy
                    scope.getTemplateUrl = function () {
                        var templateUrl = '';
                        switch (scope.managermod) {
                            case 'classical': templateUrl = currentPath + templateFolder + '/standart-typografy.html';
                                break;
                            case 'advanced': templateUrl = currentPath + templateFolder + '/advanced-typografy.html';
                        }
                        return templateUrl;
                    }



                    scope.allPlaces = jwsJson.decode(attrs.places);

                    scope.structure = jwsJson.decode(attrs.structure);


                    scope.addItem = function () {
                        scope.addNewItem();
                        scope.checkList(scope.typografy);

                        // scrool at new item
                        angular.element('html, body').animate({
                            scrollTop: angular.element('.jw-typografy-one').last().offset().top
                        }, 1000);

                    };

                    scope.addNewItem = function () {
                        if (scope.typografy === undefined || scope.typografy === '') {
                            scope.typografy = [];
                        }
                        var lastTypografy = {};
                        if (scope.typografy.length > 0) {
                            lastTypografy = angular.extend(angular.copy(scope.typografy[scope.typografy.length - 1]), { 'id': jwsUtils.getUniqueId() });
                        } else {
                            lastTypografy = angular.extend(angular.copy(styleModel), { 'id': jwsUtils.getUniqueId() });
                        }
                        lastTypografy.places = [];
                        scope.typografy.push(angular.extend(angular.copy(styleModel), lastTypografy));
                    }

                    scope.deleteItem = function (id, parent) {
                        if (confirm('Do you really want to dete this style? \nAll font places will be assigned to first style')) {
                            if (parent.length > 0) {
                                parent.splice(id, 1);
                                scope.checkList(parent);
                            }
                        }
                    };

                    scope.movePlaceActual = 0;
                    scope.movePlaceActualId = 0;
                    scope.moveStyleActual = 0;
                    scope.showContextMenu = function (place, idplace, style, event) {
                        scope.movePlaceActual = place;
                        scope.movePlaceActualId = idplace;
                        scope.moveStyleActual = style;
                        jwsContextMenu.open(angular.element('.jw-typografy-context'), angular.element('.jw-typografy-styles'), event);
                    };

                    scope.movePlace = function (style) {
                        scope.typografy[style].places.push(scope.movePlaceActual);
                        scope.typografy[scope.moveStyleActual].places.splice(scope.movePlaceActualId, 1);
                    };

                }
            };



        }]);


    /**
    * @name         ngRightClick
    * @description  Right click directive 
    *               - pouziva se zejmena pro vyvolani kontextove nabidky.
    * #tested
    */
    directives.directive('ngRightClick', function ($parse) {
        return {
            restrict: 'A',
            scope: true,
            link: function (scope, element, attrs) {
                var fn = $parse(attrs.ngRightClick);
                element.bind('contextmenu', function (event) {
                    scope.$apply(function () {
                        event.preventDefault();
                        fn(scope, { $event: event });
                    });
                });
            }
        };
    });

    /**
     * @name         copyToClipboard
     * @description  copy to clipboard directive 
     */
    directives.directive('copyToClipboard', function ($window) {
        var body = angular.element($window.document.body);
        var textarea = angular.element('<textarea/>');
        textarea.css({
            position: 'fixed',
            opacity: '0'
        });

        function copy(toCopy) {
            textarea.val(toCopy);
            body.append(textarea);
            textarea[0].select();

            try {
                var successful = document.execCommand('copy');
                if (!successful) throw successful;
            } catch (err) {
                console.log("failed to copy", toCopy);
            }
            textarea.remove();
        }

        return {
            restrict: 'A',
            link: function (scope, element, attrs) {
                element.bind('click', function (e) {
                    copy(attrs.copyToClipboard);
                });
            }
        }
    });


    /**
    * @name         tgDynamicDirective
    * @description  umoznuje do struktury dynamicky vkladat direktivy  
    */
    directives.directive('tgDynamicDirective', ['$compile',
        function ($compile) {
            'use strict';
            return {
                restrict: 'E',
                require: '^ngModel',
                scope: true,
                link: function (scope, element, attrs, ngModel) {
                    var ngModelItem = scope.$eval(attrs.ngModel);
                    scope.ngModelItem = ngModelItem;
                    scope.tgDynamicDirectiveLevel = scope.$eval(attrs.tgDynamicDirectiveLevel);
                    scope.tgDynamicDirectiveLevel++;
                    scope.viewNextLevel = true;
                    if (scope.tgDynamicDirectiveLevel > 2) {
                        scope.viewNextLevel = false;
                    }
                    var getView = scope.$eval(attrs.tgDynamicDirectiveView);
                    if (getView && typeof getView === 'function') {
                        var templateUrl = getView(ngModelItem);
                        if (templateUrl) {
                            element.html('<div ng-include src="\'' + templateUrl + '\'"></div>');
                        }
                        $compile(element.contents())(scope);
                    }
                }
            };
        }
    ]);


    /**
    * @name         jwdHelp
    * @description  zobrazuje kontextove menu napovedy a stara se o obsah.  
    * #tested
    */
    directives.directive('jwdHelp', ['$parse', 'jwsJson', function ($parse, jwsJson) {
        return {
            restrict: 'E',
            transclude: true,
            scope: {
                title: "@?",
                description: "@?",
                links: "@?",
                imgSrc: "@?",
                style: "@?",
            },
            templateUrl: currentPath + templateFolder + '/help.html',
            link: function (scope, element, attrs, ctrl, transclude) {

                transclude(scope, function (clone) {
                    if (clone.length) {
                        element.find('.jw-help').prepend(clone);
                    } else {
                        element.find('.jw-help').prepend('<div class="jw-help-icon"><i class="jaw-icon-question"></i></div>');
                    }
                });

                scope.open = false;

                scope.show = function () {
                    scope.open = true;
                    scope.baseUrl = jaw_variables['JAW_THEME_URI'] + '/help/images/';
                    scope.linksOut = jwsJson.decode(scope.links);
                    scope.imgSrcOut = scope.baseUrl + scope.imgSrc;
                    angular.element('body').one('click', function (event) {
                        scope.close();
                    });
                }

                scope.close = function () {
                    scope.open = false;
                }


            }
        };
    }]);



    /**
    * @name         jwdCheckChanges
    * @description  Kontroluje zmeny nastavovatek 
    *               - pokud byla v databazi zmenena hodnota prestu tak vyhodi hlasku
    *               - Ke zmene uze dojit napr pri editaci ve dvou oknech prohlizece
    */
    directives.directive('jwdCheckChanges', ['$rootScope', 'jwsAjaxService', 'jwsJson', function ($rootScope, jwsAjaxService, jwsJson) {
        return {
            restrict: 'E',
            scope: {
                interval: "@"
            },

            link: function (scope, element, attrs) {
                scope.showDialog = false;

                var oldColorPreset = '';
                var oldCategoryPreset = '';
                var oldSinglePreset = '';
                var oldThemeOptions = '';


                scope.setChecker = function () {
                    clearInterval(scope.timeout);
                    scope.timeout = setInterval(function () {
                        scope.check(scope.result);
                    }, scope.interval);
                }

                //odstartuju kontrolovani.
                scope.$on("jwTOLoadDone", function () {
                    scope.setChecker();
                });

                //pri ukladani vyradim checker z provozu
                scope.$on("jweBeforeSaveTO", function () {
                    clearInterval(scope.timeout);
                });

                //po ulozeni odstartuju kontrolovani
                scope.$on("jweAfterSaveTO", function () {
                    scope.setChecker();
                    oldColorPreset = undefined;
                    oldCategoryPreset = undefined;
                    oldSinglePreset = undefined;
                    oldThemeOptions = undefined;
                });


                scope.result = function (changed) {
                    if (changed.length) {
                        $rootScope.$broadcast('jweShowInfoDialog', {
                            icon: 'warning',
                            title: 'Warning',
                            description: "" + changed.join(', ') + " data has been changed. Mabye you're editing your WordPress in another tab or on another computer. To avoid rewrite, please refresh this page",
                            buttons: [
                                {
                                    title: "Ignore",
                                    click: 'hide()'
                                }
                            ],
                            interval: 50000000,
                            showBg: false
                        });
                    }
                }


                scope.check = function (callback) {
                    jwsAjaxService.send({
                        'action': 'jaw_check_changes'
                    }, function (response) {
                        var changed = [];
                        //kontrola, zda-li nebyla nejaka hodnota zemenena. 
                        //pokud AJAX narazi na PHP error, tak se hodnota rocna undefined.
                        if (oldColorPreset !== undefined
                            && response['color_preset'] !== undefined
                            && oldColorPreset !== ''
                            && response['color_preset'] !== ''
                            && oldColorPreset != response['color_preset']) {

                            changed.push('Color Presets');
                        }
                        if (oldCategoryPreset !== undefined
                            && response['category_preset'] !== undefined
                            && oldCategoryPreset !== ''
                            && response['category_preset'] !== ''
                            && oldCategoryPreset != response['category_preset']) {

                            changed.push('Category Presets');
                        }
                        if (oldSinglePreset !== undefined
                            && response['single_preset'] !== undefined
                            && oldSinglePreset !== ''
                            && response['single_preset'] !== ''
                            && oldSinglePreset != response['single_preset']) {

                            changed.push('Single Presets');
                        }
                        if (oldThemeOptions !== undefined
                            && response['theme_options'] !== undefined
                            && oldThemeOptions !== ''
                            && response['theme_options'] !== ''
                            && oldThemeOptions != response['theme_options']) {

                            changed.push('Theme Options');
                        }

                        callback(changed);

                        oldColorPreset = response['color_preset'];
                        oldCategoryPreset = response['category_preset'];
                        oldSinglePreset = response['single_preset'];
                        oldThemeOptions = response['theme_options'];

                    });
                }


            }
        };
    }]);

    /** 
     * @name            jwdInfoDialog
     * @description     Show info dialog in Theme Options
     */
    directives.directive('jwdInfoDialog', ['$parse', '$timeout', '$compile', function ($parse, $timeout, $compile) {
        return {
            restrict: 'E',
            scope: true,
            templateUrl: currentPath + templateFolder + '/info-dialog.html',
            link: function (scope, element, attrs) {
                scope.showBg = false;
                scope.$on("jweShowInfoDialog", function (event, args) {
                    scope.icon = args.icon;
                    scope.title = args.title;
                    scope.description = args.description;
                    scope.buttons = args.buttons;
                    scope.showBg = args.showBg;
                    scope.show(args.interval);
                });

                scope.callFunc = function (exp) {
                    $parse(exp)(scope); //Parse the function name to get the expression and invoke it on the scope
                }

                /** 
                * @name            show
                * @description     Function which show dialog for X seconds
                * 
                * @param {int} interval How long will be dialog shown
                */
                scope.show = function (interval) {
                    scope.showDialog = true;
                    if (interval > 0) {
                        setTimeout(scope.hide, interval);
                    }
                };
                scope.hide = function () {
                    $timeout(function () {
                        scope.$apply(function () {
                            scope.showDialog = false;
                            scope.showBg = false;
                        });
                    });
                };
            }
        };
    }]);


    /**
     * @name        jwdThemereq (checker)
     * @description Kontroluje theme requipements pomocí AJAXu
     */
    directives.directive('jwdThemereq', ['$parse', 'jwsAjaxService', function ($parse, jwsAjaxService) {
        return {
            restrict: 'E',
            scope: true,
            templateUrl: currentPath + templateFolder + '/themechecker.html',
            link: function (scope, element, attrs) {
                scope.errmsg = "Loading...";
                scope.$on("jwTOLoadDone", function () {
                    //nacte se info z cache
                    scope.check('cache');
                });
                scope.refresh = function () {
                    //kdyz kliknu na "check now" tak se to zkontroluje
                    scope.errmsg = "Loading...";
                    scope.check('refresh');
                };
                scope.check = function (status) {
                    jwsAjaxService.send({
                        'action': 'jaw_checker',
                        'status': status
                    }, function (response) {
                        if (response == -1) { //failed
                            scope.errmsg = "AJAX error";
                        } else {
                            scope.errmsg = "";
                            scope.info = response;
                        }
                    });
                }
            }
        }
    }]);


    /**
     * @name        jwdChangelog
     * @description Zobrazuje aktualni changelog (co se zmenilo od posledni verze)
     */
    directives.directive('jwdChangelog', ['$parse', 'jwsAjaxService', function ($parse, jwsAjaxService) {
        return {
            restrict: 'E',
            scope: true,
            template: '<div class="jaw-changelog-ajax" ng-bind-html="changelog|trustAsHtml"></div>',
            link: function (scope, element, attrs) {
                scope.changelog = "Loading changelog...";
                scope.$on("jwTOLoadDone", function () {
                    scope.check();
                });
                scope.check = function () {
                    jwsAjaxService.send({
                        'action': 'jaw_changelog'
                    }, function (response) {
                        if (response == -1) { //failed
                            scope.changelog = "Error";
                        } else {
                            scope.changelog = response;
                        }
                    });
                }
            }
        }
    }]);


    /**
     * @name        jwdPreviewBanner
     * @description Zobrazuje banner na backendu (nahled v revoComposeru - aby si user nemusel pamatovat jaky banner ma kde prirazeny)
     */
    directives.directive('jwdPreviewBanner', ['$parse', 'jwsAjaxService', function ($parse, jwsAjaxService) {
        return {
            restrict: 'E',
            scope: {
                banner: '='
            },
            template: '<i class="jaw-icon-spinner2 jaw-spinit" ng-show="loader"></i><div class="jaw-preview-banner" ng-bind-html="bannerContent|trustAsHtml"></div>',
            link: function (scope, element, attrs) {
                scope.bannerContent = "";
                scope.loader = false;
                scope.$watch('banner', function (newValue, oldValue) {
                    scope.loader = true;
                    scope.bannerContent = "";
                    jwsAjaxService.send({
                        'action': 'jaw_print_shortcode',
                        'shortcode': 'jaw_banner',
                        'attrs': { 'custom_banner': scope.banner }
                    }, function (response) {
                        scope.loader = false;
                        if (response !== '') {
                            scope.bannerContent = response;
                        } else {
                            scope.bannerContent = "Banner isn't set";
                        }
                    });
                });



            }
        }
    }]);


    directives.directive('jwdToggle', ['$parse', '$timeout', 'jwsJson', function ($parse, $timeout, jwsJson) {
        return {
            restrict: 'E',
            scope: {
                selected: '='
            },
            templateUrl: currentPath + templateFolder + '/toggle.html',
            link: function (scope, element, attrs) {

                $timeout(function () {
                    scope.options = jwsJson.decode(attrs.options);
                });
                scope.change = function (select) {
                    scope.selected = select;
                }
            }
        }
    }]);


    directives.directive('jwdDemo', ['$parse', '$timeout', '$rootScope', 'jwsJson', 'jwsAjaxService', function ($parse, $timeout, $rootScope, jwsJson, jwsAjaxService) {
        return {
            restrict: 'E',
            templateUrl: currentPath + templateFolder + '/demo.html',
            link: function (scope, element, attrs) {

                scope.imgPath = jaw_variables['JAW_THEME_URI'] + '/demo/screens/';
                scope.error = false;
                scope.processType = '';
                scope.progress = 0;
                scope.actualDemoID = 0;

                $timeout(function () {
                    scope.demos = jwsJson.decode(attrs.demos);
                    scope.installed = jwsJson.decode(attrs.installed);
                });

                scope.installDemoClick = function (demoId) {
                    scope.actualDemoID = demoId;
                    var description = "Do you want to proceed?";
                    if (scope.installed == {}) {
                        description = "This demo will be added to demos, you've installed earlier. Do you want to proceed?";
                    } else {
                        description = "Please make sure, that you've installed all required plugins.<br><br>This will install some posts, categories, menus, attachements, etc.. into your wordpress. Do you want to proceed?";
                    }
                    $rootScope.$broadcast('jweShowInfoDialog', {
                        icon: 'info',
                        title: '',
                        description: description,
                        buttons: [
                            {
                                title: "Yes",
                                click: 'installDemo();hide();'
                            },
                            {
                                title: "No",
                                click: 'hide()'
                            }
                        ],
                        showBg: true
                    });
                };

                scope.installDemo = function () {
                    $rootScope.$broadcast('jweBeforeSaveTO');
                    scope.error = false;
                    scope.processType = 'install';

                    jQuery('html, body').animate({
                        scrollTop: 0
                    }, 350);

                    jQuery(".cover_load").show();
                    jQuery(".cover_load").width(jQuery(window).width());
                    jQuery(".cover_load").css({
                        'min-height': jQuery('#wpwrap').height() + 50,
                        'top': jQuery(".cover_load").parent().offset().top * -1,
                        'left': jQuery(".cover_load").parent().offset().left * -1,
                    });
                    console.log(scope.processType);
                    var nonce = jQuery('#jaw_security').val();

                    scope.callImport(scope.actualDemoID, nonce);

                };



                scope.callImport = function (demoId, nonce) {
                    jwsAjaxService.send({
                        action: 'jaw_ajax_action',
                        type: 'import_demo',
                        security: nonce,
                        demoId: demoId
                    }, function (response) {
                        jsonResponse = jwsJson.decode(response);
                        console.log(jsonResponse);
                        if (jsonResponse.errors != null && jsonResponse.errors.length > 0) {
                            scope.error = jsonResponse.errors.join(', ');
                        } else if (jsonResponse.done === undefined) {
                            scope.error = response.replace(/<(?:.|\n)*?>/gm, '');
                        } else if (!jsonResponse.done) {
                            scope.progress = jsonResponse.imported / jsonResponse.numberOfAttachements * 100;
                            scope.callImport(demoId, nonce);
                        } else {
                            scope.progress = 100;
                            scope.processType = 'installDone';
                        }
                    }, function (error) {
                        scope.error = error.responseText;
                    });
                }


                scope.uninstallDemoClick = function (demoId) {
                    scope.actualDemoID = demoId;
                    $rootScope.$broadcast('jweShowInfoDialog', {
                        icon: 'info',
                        title: '',
                        description: "This will uninstall data related to this demo only. Do you really want to proceed?",
                        buttons: [
                            {
                                title: "Yes",
                                click: 'uninstallDemo();hide();'
                            },
                            {
                                title: "No",
                                click: 'hide()'
                            }
                        ],
                        showBg: true
                    });
                };

                scope.uninstallDemo = function (callback) {
                    $rootScope.$broadcast('jweBeforeSaveTO');
                    scope.error = false;
                    scope.processType = 'uninstall';

                    jQuery('html, body').animate({
                        scrollTop: 0
                    }, 350);

                    jQuery(".cover_load").show();
                    jQuery(".cover_load").width(jQuery(window).width());
                    jQuery(".cover_load").css({
                        'min-height': jQuery('#wpwrap').height() + 50,
                        'top': jQuery(".cover_load").parent().offset().top * -1,
                        'left': jQuery(".cover_load").parent().offset().left * -1,
                    });

                    var nonce = jQuery('#jaw_security').val();
                    jwsAjaxService.send({
                        action: 'jaw_ajax_action',
                        type: 'uninstal_demo',
                        security: nonce,
                        demoId: scope.actualDemoID
                    }, function (response) {
                        scope.processType = 'uninstallDone';
                        if (callback !== undefined) {
                            callback();
                        }
                    }, function (response) {
                        scope.error = response.responseText;
                    });
                };



                scope.reinstallDemoClick = function (demoId) {
                    scope.actualDemoID = demoId;
                    $rootScope.$broadcast('jweShowInfoDialog', {
                        icon: 'info',
                        title: '',
                        description: "This will uninstall remaining data related to this demo and install it back. Do you really want to proceed?",
                        buttons: [
                            {
                                title: "Yes",
                                click: 'reinstallDemo();hide();'
                            },
                            {
                                title: "No",
                                click: 'hide()'
                            }
                        ],
                        showBg: true
                    });
                };

                scope.reinstallDemo = function () {
                    scope.uninstallDemo(scope.installDemo);
                };
            }
        }
    }]);




    directives.directive('jwdSidebarManager', ['$parse', '$rootScope', 'jwsAjaxService', 'jwsEditData', function ($parse, $rootScope, jwsAjaxService, jwsEditData) {
        return {
            restrict: 'E',
            scope: {
                sidebars: "="
            },
            templateUrl: currentPath + templateFolder + '/sidebar-manager.html',
            link: function (scope, element, attrs) {
                scope.sidebars = scope.sidebars || {};

                scope.info = "plus";

                scope.add = function (item, attrs) {
                    jwsEditData.add(item, attrs);
                    scope.sendData(scope.sidebars);
                }

                scope.delete = function (where, id) {
                    if (confirm('Are you sure?')) {
                        jwsEditData.delete(where, id);
                        scope.sendData(scope.sidebars);
                    }
                }


                scope.sendData = function (data) {
                    $rootScope.$broadcast('jweBeforeSaveTO');
                    scope.saveInfoLoad();
                    jwsAjaxService.send({
                        action: 'jaw_add_sidebar',
                        data: data,

                    }, function (response) {
                        if (response == -1) { //failed
                            scope.newName = "AJAX error";
                        } else {
                            scope.newName = "";
                        }
                        scope.saveInfoOk();
                        $rootScope.$broadcast('jweAfterSaveTO');
                    });
                }

                scope.saveInfoLoad = function () {
                    scope.info = "spinner2";
                }

                scope.saveInfoOk = function () {
                    scope.info = "checkmark";
                    setTimeout(function () {
                        scope.$apply(function () {
                            scope.info = "plus";
                        });
                    }, 2000);
                }
            }
        }
    }]);




    directives.directive('jwdWelcomeGuide', ['$timeout', '$rootScope', 'jwsAjaxService', 'jwsJson', function ($timeout, $rootScope, jwsAjaxService, jwsJson) {
        return {
            restrict: 'E',
            templateUrl: currentPath + templateFolder + '/welcome-guide.html',
            link: function (scope, element, attrs) {
                scope.step = 1;
                if (window.location.hash !== '') {
                    scope.step = window.location.hash.replace('#', '');
                }

                var tgmpaNonce = '';
                scope.plugins = {};
                scope.pluginIndex = 0;

                $timeout(function () {
                    tgmpaNonce = attrs.nonce;
                    scope.plugins = jwsJson.decode(attrs.plugins);
                    scope.installedDemos = jwsJson.decode(attrs.installedDemos);
                    if (scope.step == 4 && Object.keys(scope.installedDemos).length > 0) {
                        scope.goToStep(5);
                    }
                });
                
                scope.skipTutorial = function () {
                    jwsAjaxService.send({
                        action: 'jaw_install_cancel'
                    }, function (response) {
                        //redirect to theme opitons
                        // 
                        window.location.replace('themes.php?page=optionsframework');
                        // 
                        // 
                    });
                };

                scope.goToStep = function (step) {
                    window.location.hash = step;
                    scope.step = step;
                    switch (step) {
                        case 3: scope.installPlugins();
                            break;
                        case 4: scope.step = scope.step - 1;
                            location.reload(); //reload (kvuli pluginum)
                            break;
                    }

                };

                scope.installPlugins = function () {
                    scope.instalOnePlugin(scope.plugins[scope.pluginIndex]);
                };

                scope.instalOnePlugin = function (plugin) {
                    scope.plugins[scope.pluginIndex].icon = 'spinner2 jaw-spinit';
                    jwsAjaxService.send({
                        action: 'jaw_install_plugins',
                        'tgmpa-nonce': tgmpaNonce,
                        plugin: plugin.slug,
                    }, function (response) {
                        if (response.indexOf('Plugin install failed') > 0) {
                            scope.plugins[scope.pluginIndex].icon = 'close';
                        } else {
                            scope.plugins[scope.pluginIndex].icon = 'checkmark';
                        }
                        scope.pluginIndex++;
                        if (scope.plugins[scope.pluginIndex] !== undefined) {
                            scope.instalOnePlugin(scope.plugins[scope.pluginIndex]);
                        } else {
                            scope.pluginIndex = 999;
                        }
                    });
                }

            }
        }
    }]);

})(angular, window, jaw_variables);