describe("jwPbServices", function () {
	var $controller;
		
	beforeEach(function(){
		module("jwPbServices");
	});
	
	beforeEach(inject(function(_$controller_){
		$controller = _$controller_;
	}));
	
	describe("value: jwPbDefaultContents", function(){
		var value = null;
		beforeEach(inject(function(jwPbDefaultContents) {
			value = jwPbDefaultContents;
		}));
		//cannot test - je to tam nadefinovany z drivejsich testu @todo
		// it("Init", function() {
		// 	expect(value).toEqual({});
		// });
		it("set value", function(){
			value.content = {test: 123};
			expect(value).toEqual({content:{test:123}});
		});
	}); /* END jwPbDefaultContents */
	
	describe("factory: jwPbConfig", function(){
		var factory = null;
		beforeEach(inject(function(jwPbConfig) {
			factory = jwPbConfig;
		}));

		it("set&get", function(){
			factory.set([{id:"test", name: "TEST", size: 12}]);
			expect(factory.get("test","name")).toEqual("TEST");
			expect(factory.get("test","size")).toEqual(12);
		});
	});/* END jwPbConfig */
	
	
	describe("factory: jwPbElementService", function(){
		var factory = null;
		beforeEach(inject(function(jwPbElementService) {
			factory = jwPbElementService;
		}));

		it("add", function(){
			var item = {
				id: 15,
				type: 'test'
			}
			expect(factory.add(item)).toEqual({
				id: 15,
				type: 'test',
				size: 12,
				metabox: {title: 'Title'},
				visible: true,
				childs: []
				});			
		});
		// jak to testovat? @todo
		// if("edit", function(){
		// 	
		// });
		
		it("changeSize", function(){
			var item = {
				id: 15,
				type: 'test',
				size: 6,
				metabox: {title: 'Title'},
				visible: true,
				childs: []
				};
			factory.changeSize(item, true);
			expect(item.size).toEqual(7);
			factory.changeSize(item, false);
			expect(item.size).toEqual(6);
		});
		
		it("changeSize on right sidebar", function(){
			var item = {
				id: 'test_right',
				type: 'test',
				size: 6,
				metabox: {title: 'Title'},
				visible: true,
				childs: []
				};
			factory.changeSize(item, true);
			expect(item.size).toEqual(5);
			factory.changeSize(item, false);
			expect(item.size).toEqual(6);
		});
		
		it("changeSizeAt", function(){
			var item = {
				id: 'test_right',
				type: 'test',
				size: 6,
				metabox: {title: 'Title'},
				visible: true,
				childs: []
				};
			factory.changeSizeAt(item, 9);
			expect(item.size).toEqual(9);
			expect(function(){factory.changeSizeAt(item, 15)}).toThrow(new Error("Cannot set bigger than 12"));
			expect(item.size).toEqual(9);
		});
		
	});/* END jwPbElementService */
	
	describe("factory: jwPbWorkspaceService", function(){
		var factory = null;
		var default_contents_factory = null;
		beforeEach(inject(function(jwPbWorkspaceService, jwPbDefaultContents) {
			factory = jwPbWorkspaceService;
			default_contents_factory = jwPbDefaultContents;
		}));
		
		it("init", function(){
			expect(factory.init()).toEqual({}); 	
		});
		it("init with default", function(){
			default_contents_factory.content = {test_1: { aa: {id: 'header', size: 2}}, test_2: { aa: {id: 'content',type: 'test'}}};
			expect(factory.init()).toEqual({
				'header': {
					id: 'header',
					type: '',
					size: 2,
					metabox: {title: 'Title'},
					visible: true,
					childs: []
				},
				'content': {
					id: 'content',
					type: 'test',
					size: 12,
					metabox: {title: 'Title'},
					visible: true,
					childs: []
				}
			}); 	
		});
		it("init with data", function(){
			expect(factory.init({test:'neco'})).toEqual({test:'neco'}); 	
		});
		
		it("add", function(){
			var childs = [];
			expect(factory.add(childs, {id:25})).toEqual(
				{id: 25,
				type: '',
				size: 12,
				metabox: {title: 'Title'},
				visible: true,
				childs:[]
				}); 	
		});
		it("delete", function(){
			var childs = {id: 25,
				type: '',
				size: 12,
				metabox: {title: 'Title'},
				visible: true,
				childs:[{aa:25}]
				};
			expect(factory.delete(0, childs)).toEqual(true); 	
		});
		it("delete out of range", function(){
			var childs = {id: 25,
				type: '',
				size: 12,
				metabox: {title: 'Title'},
				visible: true,
				childs:[{aa:25}]
				};
			expect(factory.delete(5, childs)).toEqual(false); 	
		});
	}); /* END jwPbWorkspaceService */
	
	
});