describe("jwPbControllers", function(){
	var $rootScope,
		$scope,
		$window,
		controller;


	beforeEach(function(){
		module("jwPbControllers");
		
		inject(function($injector){
			$rootScope = $injector.get("$rootScope");
			$scope = $rootScope.$new();
			$window = window;
			controller = $injector.get("$controller")("jwPbBuilderController", {$scope: $scope, $window:$window});	
		});
	}); 
	
	
	describe("Initialization", function(){
		it("Should init PRESETS to blank array", function(){
			expect($scope.presets).toEqual([]);
		});
		it("Should init CURRENT_BOOKMARK to HOME", function(){
			expect($scope.current_bookmark).toEqual('bookmark-build_bookmark_home');
		});
		it("Should init SEARCHTEXT to blank string", function(){
			expect($scope.searchText).toEqual("");
		});
		it("Should init LOADER to blank array", function(){
			expect($scope.loader).toEqual([]);
		});
		it("Should init WORKSPACE to blank", function(){
			expect($scope.workspace).toEqual({});
		});
		it("Should init BUILDER_WS_INDEX to 0", function(){
			expect($scope.builder_ws_index).toEqual(0); 
		});
		it("Should init ISINITIALIZED to blank stzring", function(){
			expect($scope.isInitalized).toEqual("");
		});
		it("Should init contextMenuTimer to false", function(){
			expect($scope.contextMenuTimer).toEqual(false);
		});
		it("Should init contextMenuItem to false", function(){
			expect($scope.contextMenuItem).toEqual({});
		});
	});	 /* END Initialization */ 
	
	
	describe("Initialization - functions", function(){
		describe("initIndex",function(){
			it("index is number", function(){
				expect($scope.builder_ws_index).toEqual(0);
				$scope.init_index(5);
				expect($scope.builder_ws_index).toEqual(5);
			});
			
			it("index is null", function(){
				expect($scope.builder_ws_index).toEqual(0);
				$scope.init_index(null);
				expect($scope.builder_ws_index).toEqual(0);
			});
			
			it("index is undefined", function(){
				expect($scope.builder_ws_index).toEqual(0);
				$scope.init_index();
				expect($scope.builder_ws_index).toEqual(0);
			});
			
		    it("index is false", function(){
				expect($scope.builder_ws_index).toEqual(0);
				$scope.init_index(false);
				expect($scope.builder_ws_index).toEqual(0);
			});
			
			it("index is string", function(){
				expect($scope.builder_ws_index).toEqual(0);
				$scope.init_index("some text");
				expect($scope.builder_ws_index).toEqual(0);
			});
		}); /* END initIndex */
		
		describe("init_builder", function(){
			beforeEach(function(){
				inject(function($injector){
					$window.jw_pb = [{"test":0}];
					$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12}]}
					$window.jw_fields = [];
				});
			});
			
			it("WORKSPACE is initialized", function(){
				expect($scope.workspace).toEqual({});
				$scope.init_builder(0);
				expect($scope.workspace).toEqual({"test":0});
				expect($scope.isInitalized).toEqual("initialized");
			});
			
			it("WORKSPACE is initialized by false", function(){
				$window.jw_pb = [false];
				expect($scope.workspace).toEqual({});
				$scope.init_builder(0);
				expect($scope.workspace).toEqual({ '2_content': { id: '2_content', type: 'content', size: 12, metabox: { title: 'Title' }, visible: true, childs: [  ]}});
				expect($scope.isInitalized).toEqual("initialized");
			});
			
			it("WORKSPACE is initialized by null", function(){
				$window.jw_pb = [null];
				expect($scope.workspace).toEqual({});
				$scope.init_builder(0);
				expect($scope.workspace).toEqual({ '2_content': { id: '2_content', type: 'content', size: 12, metabox: { title: 'Title' }, visible: true, childs: [  ]}});
				expect($scope.isInitalized).toEqual("initialized");
			});
			
			it("WORKSPACE is initialized by blank", function(){
				$window.jw_pb = [];
				expect($scope.workspace).toEqual({});
				$scope.init_builder(0);
				expect($scope.workspace).toEqual({ '2_content': { id: '2_content', type: 'content', size: 12, metabox: { title: 'Title' }, visible: true, childs: [  ]}});
				expect($scope.isInitalized).toEqual("initialized");
			});
			
			it("WORKSPACE is independent", function(){
				$window.jw_pb = [{"test":0}, {"aaa":5}];
				expect($scope.workspace).toEqual({});
				$scope.init_builder(0);
				expect($scope.workspace).toEqual({"test":0});
				expect($scope.isInitalized).toEqual("initialized");
				expect($scope.workspace).toEqual({"test":0});
				$scope.init_builder(1);
				expect($scope.workspace).toEqual({"aaa":5});
				expect($scope.isInitalized).toEqual("initialized");
			});
			
		}); /* END init_builder */
	}); /* END Initialization - functions */
	
	
	
	

	describe("Work with elements", function(){
		
		
		
		 describe("Add new element", function(){
			 beforeEach(function(){
				inject(function($injector){
					$window.jw_pb = [];
					$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12}]}
					$window.jw_fields = [];
					$scope.init_index(5);
					$scope.init_builder(0);
				});
			});
			
			 it("Add new element to blank workspace", function(){ 
				$scope.add_element({type:'blog', size:'6'},'2_content');
				expect($scope.workspace).toEqual({ '2_content': {
					 id: '2_content', 
					 type: 'content', 
					 size: 12, 
					 metabox: { title: 'Title' }, 
					 visible: true, 
					 childs: [ {
						 id: 5, 
						 type: 'blog', 
						 size: '6', 
						 metabox: { title: 'Title' },  
						 visible: true, 
						 childs: [  ]
					 } ], 
					 }});
			 });
			 
			 it("Add new element to blank workspace - check revrite ID", function(){ 
				$scope.add_element({type:'blog', size:'12', id: 10},'2_content');
				expect($scope.workspace).toEqual({ '2_content': {
					 id: '2_content', 
					 type: 'content', 
					 size: 12, 
					 metabox: { title: 'Title' }, 
					 visible: true, 
					 childs: [ {
						 id: 5, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Title' },  
						 visible: true, 
						 childs: [  ]
					 } ], 
					 }});
			 });
			 
			 
			 it("Add new element to not empty workspace", function(){
				$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12, childs: [ {
						 id: 5, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Title' },  
						 visible: true, 
						 childs: [  ]
					 } ], }]} ;
				$scope.init_index(6);
				$scope.init_builder(0);
				$scope.add_element({type:'title', size:'12', id: 10},'2_content');
				expect($scope.workspace).toEqual({ '2_content': {
					 id: '2_content', 
					 type: 'content', 
					 size: 12, 
					 metabox: { title: 'Title' }, 
					 visible: true, 
					 childs: [ {
						 id: 5, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Title' },  
						 visible: true, 
						 childs: [  ]
					 }, 
					 {
						 id: 6, 
						 type: 'title', 
						 size: '12', 
						 metabox: { title: 'Title' },  
						 visible: true, 
						 childs: [  ]
					 } ]
					 }});
			 });
		});	 /* END Add new element */
			 
			 
			 
			 
			 
		describe("Delete an element", function(){
			 beforeEach(function(){
				inject(function($injector){
					$window.jw_pb = [];
					$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12, childs: [ 
						{
						 id: 5, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Title' },  
						 visible: true, 
						 childs: [  ]
					 } ], }]};
					$window.jw_fields = [];
					$scope.init_index(10);
					$scope.init_builder(0);
				});
			});
			
			 
			 it("Delete element", function(){
				$scope.delete_element(0, $scope.workspace['2_content']);
				expect($scope.workspace).toEqual({ '2_content': {
					 id: '2_content', 
					 type: 'content', 
					 size: 12,   
					 metabox: { title: 'Title' }, 
					 visible: true, 
					 childs: []
					 }});
			 });
			 
		 }); /* END Delete an element */
		 
		 
		 
		 describe("Clone an element", function(){
			 beforeEach(function(){
				inject(function($injector){
					$window.jw_pb = [];
					$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12, childs: [ 
						{
						 id: 5, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 } ], }]};
					$window.jw_fields = [];
					$scope.init_index(10);
					$scope.init_builder(0);
				});
			});
			
			 
			 it("clone element", function(){
				$scope.clone_element($scope.workspace['2_content'].childs[0], $scope.workspace['2_content']);
				expect($scope.workspace).toEqual({'2_content':{
					'id': '2_content', 
					'type': 'content', 
					'size': 12,  
					metabox: { title: 'Title' },  
					visible: true, 
					childs: [ 
					{
						 id: 5, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 },
					 {
						 id: 10,  
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 },
					  ], }}); 
			 });
			 
		 }); /* END clone an element */
		 
		 
		 
		  describe("Change size", function(){
			 beforeEach(function(){
				inject(function($injector){
					$window.jw_pb = [];
					$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12, childs: [ 
						{
						 id: 5, 
						 type: 'blog', 
						 size: '6', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 },
					 {
						 id: 6, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 },
					 {
						 id: 7, 
						 type: 'blog', 
						 size: '1', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 },
					 {
						 id: 'sidebar_right', 
						 type: 'sidebar', 
						 size: '6', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }
					  ], }]};
					$window.jw_fields = [];
					$scope.init_index(10);
					$scope.init_builder(0);
				});
			});
			
			 
			 it("Change size down", function(){
				$scope.change_size($scope.workspace['2_content'].childs[0], false);
				expect($scope.workspace['2_content'].childs[0]).toEqual(
					{
						 id: 5, 
						 type: 'blog', 
						 size: 5, 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }); 
			 });
			 
			 it("Change size up", function(){
				$scope.change_size($scope.workspace['2_content'].childs[0], true);
				expect($scope.workspace['2_content'].childs[0]).toEqual(
					{
						 id: 5, 
						 type: 'blog', 
						 size: 7, 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }); 
			 });
			 
			 it("Check upper limit", function(){
				$scope.change_size($scope.workspace['2_content'].childs[1], true);
				expect($scope.workspace['2_content'].childs[1]).toEqual(
					{
						 id: 6, 
						 type: 'blog', 
						 size: '12', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }); 
			 });
			 
			 
			 it("Check down limit", function(){
				$scope.change_size($scope.workspace['2_content'].childs[2], false);
				expect($scope.workspace['2_content'].childs[2]).toEqual(
					{
						 id: 7, 
						 type: 'blog', 
						 size: '1', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }); 
			 });
			 
			 it("Check resizing of right sidebar", function(){
				$scope.change_size($scope.workspace['2_content'].childs[3], false);
				expect($scope.workspace['2_content'].childs[3]).toEqual(
					{
						 id: 'sidebar_right', 
						 type: 'sidebar', 
						 size: 7, 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }); 
			 });
			 
		 }); /* END Change size */
		 
		  describe("Set fullwidth", function(){
			 beforeEach(function(){
				inject(function($injector){
					$window.jw_pb = [];
					$window.jw_areas = {'content': [{'id': '2_content', 'type': 'content', 'size': 12, childs: [ 
						{
						 id: 5, 
						 type: 'blog', 
						 size: '6', 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 	}
					  ], }]};
					$window.jw_fields = [];
					$scope.init_index(10);
					$scope.init_builder(0);
				});
			});
			
			 
			 it("set_fullwidth", function(){
				$scope.set_fullwidth($scope.workspace['2_content'].childs[0]);
				expect($scope.workspace['2_content'].childs[0]).toEqual(
					{
						 id: 5, 
						 type: 'blog', 
						 size: 12, 
						 metabox: { title: 'Test' },  
						 visible: true, 
						 childs: [  ]
					 }); 
			 });
			 
		 }); /* END Change size */
		 
		 
		 
	});	/* END Work with elements  */
	
	
});
