describe("jwEditor", function(){
	var $rootScope,
		$scope,
		$window,
		controller;


	beforeEach(function(){
		module("jwEditor");
		
		inject(function($injector){
			$rootScope = $injector.get("$rootScope");
			$scope = $rootScope.$new();
			$window = window;
			controller = $injector.get("$controller")("jwEditorController", {$scope: $scope, $window:$window});	
		});
	});
	
	function getElement() {
		var element = angular.element('<div id="editor_container_999"><div class="content"><div class="section sub_all">1</div><div class="section sub_all">2</div></div></div>');
		document.body.appendChild(element[0]);
		return element;
	}
	
	
	describe("Initialization", function(){
		it("Should init EDIT to blank object", function(){
			expect($scope.edit).toEqual({});
		});
		it("Should init JAW_OPTIONS to blank object", function(){
			expect($scope.options).toEqual({});
		});
		it("Should init LOADER to blank array", function(){
			expect($scope.loader).toEqual([]);
		});
		it("Should init LOADER-OPEN to false", function(){
			expect($scope.isSomeLoaderOpen).toEqual(false);
		});
		it("Should init ACTIVE BOOKMARK to 0", function(){
			expect($scope.active_bookmark).toEqual(0);
		});
	});	 /* END Initialization */ 
	
	
	describe("Init editor", function(){
		it("Should init EDIT to blank object", function(){
			$scope.init_editor('666');
			expect($scope.editor_index).toEqual('666');
		});
	});	 /* END init editor */ 
	
	
	describe("Switch bookmarks", function(){
		var id = 999;
		var element;
		var firstElement;
		var secondElement;
		beforeEach(function(){
			$scope.init_editor(id);
			element = getElement();
			firstElement = angular.element('#editor_container_' + id + ' .content > .section.sub_all').eq(0);
			secondElement = angular.element('#editor_container_' + id + ' .content > .section.sub_all').eq(1);
		});
		afterEach(function(){
			document.body.removeChild(element[0]);
		});
		it("Switch to 1 bookmark", function(){
			$scope.switch_mark(0);
			expect(firstElement.is(":hidden")).toBe(false); // Passes
			expect(secondElement.is(":hidden")).toBe(true); // Passes
		});
		it("Switch to 2 bookmark", function(){
			$scope.switch_mark(1);
			expect(firstElement.is(":hidden")).toBe(true); // Passes
			expect(secondElement.is(":hidden")).toBe(false); // Passes 
		});
	});	 /* END Switch bookmarks*/ 
	
	 
	describe("Test getStyle", function(){
		it('get background', function(){
			var style = $scope.getStyle("background", "#666666");; 
			expect(style).toEqual({"background": "#666666"});
		}); 
		it('get color', function(){
			var style = $scope.getStyle("color", "#999999");; 
			expect(style).toEqual({"color": "#999999"});
		});  
		it('get font-size', function(){
			var style = $scope.getStyle("font-size", "24px");; 
			expect(style).toEqual({"font-size": "24px"});
		}); 
	});	 /* END Test getStyle */ 
	
	
});
