Vytvoření DEMO obsahu
=====================

Main content (posty, categorie, menu, obrázky, ...) jsou v `demo_base.php`

Obsah zavislý na daném demo stylu (theme options, presety, widgety ...) je v `demoX.php`

Obsav v `demo_base.php` se spojí s `demoX.php` - obě pole jsou mergovány.


Logika obsahu je následující
-----------------------------

Logika souborů není úplně nejlepší, ale v závislosti na zachování co největší jednoduchosti struktury složek a souborů mě nic lepšího nenapadlo. Vše je navrženo s důrazem na případnou jednoduchou editaci - Když se někdo rozhodne zmenit barvu v demu, tak aby se nemuselo všechno base64 dekodovat atd...

Struktura vráceného pole odpovídá struktuře složek.

Např.: Složka `/demo01/options/jaw_color_preset/` vytvoří v demo01.php hodnotu: `$jaw_demo_content["options"]["jaw_color_preset"]`

Obsah této hodnoty bude následující, nejdřív se jí přiřadí hodnota _static.txt (bez jakéhokoliv zpracování (base64, ...))

Poté je jako zanořená hodnota pole předána hodnota ostatních souborů.

Např.: Soubor `/demo01/options/jaw_color_preset/value.txt` vytvoří v demo01.php hodnotu: `$jaw_demo_content["options"]["jaw_color_preset"][NAZEV_SOUBORU_V_TOMTO_PRIPADE_"value"] = ZDE_JE_OBSAH_TXT_SOUBORU_V_BASE64`


------------------------------------------------------------------------------------------------------------------------


Značky v obsahu (Replace)
-------------------------

{{WP_TAXONOMY_nazev-taxonomie_TERM_nazev-termu}} - Místo teto značky se vloží ID příslušného termu 

{{WP_UPLOAD_FOLDER}} - Zamění tuto značku za upload folder `wp_upload_dir()` (např. http://neco.com/wp-content/uploads/)

{{WP_POST_nazev-postu}} - Zamění tuto značku za ID postu/page

{{WP_ATTACHMENT_filename}} - Zamění tuto značku za ID attachmentu (viz sekce Obrázky)

- pozn. Ideálně všechny serializované proměnné typu string převést na integer. (Neví se kolik znaků  bude ID obrázku mít)  `s:4:"2856";` => `i:{{WP_POST_Welcome page}};` 



Terms
-----

Konfigurace termů:

    $jaw_demo_content['terms']['TAXONOMY_NAME'][] = array(
		'name' => 'NAZEV_KATEGORIE',
		'slug' => 'slug-kategorie',
		'description' => '',
		'parent' => ''
	);



Obrázky
-------

Nakopírovat ve výsledném formátu do složky /demo/images/

Poté přidat do demo_base.php

    $jaw_demo_content['attachments'][] = array(
		'title' => 'NAZEV',
		'filename' => 'OBRAZEK.jpg',
		'time' => '2015/10'
	);



Posty / Page / CustomPosty
-----------------------

Jedntný obsah postů vložit do:

    $jaw_demo_content['posts_content']['POST_TYPE'] = 'BASE64_CONTENT';
	
Jednotlivé položky pak:

    $jaw_demo_content['posts'][] = array(
		'post_title' => 'NAZEV_POSTU',
		'post_type' => 'post',
		'post_author' => '1',
		'thumbnail' => 'OBRAZEK.jpg',
		'tax_input' => array('TAXONOMY_NAME' => array('TERM_SLUG')),
		'metadata' => array(
			'META_KEY' =>  'BASE64_CONTENT'
			)
	);

Pokud chci obsah v nějakém postu změnit, stačí u postu nadefinovat atribut `post_content`. 

    $jaw_demo_content['posts'][] = array(
		...
		'post_content' => 'BASE64_CONTENT',
		...
	);
	
	
MENU
-----

Menu je defakto kategorie termu `nav_menu` ve které jsou posty typu `nav_menu_item`. 

Vytvoření menu:

	$jaw_demo_content['terms']['nav_menu'][] = array(		
		'name' => 'NAZEV_MENU',
		'slug' => 'slug-menu',
		'description' => '',
		'parent' => ''
	);
	
Vložení položek do menu (metadata musí být kódovány BASE64):

    $jaw_demo_content['posts'][] = array(
		'post_title' => 'NAZEV_POLOZKY',
		'post_type' => 'nav_menu_item',
		'post_author' => '1',
		'menu_order' => '1',
		'tax_input' =>  array('nav_menu' => array('slug-menu')),
		'metadata' => array(
			'_menu_item_type' => 'cG9zdF90eXBl',
			'_menu_item_menu_item_parent' => 'MA==',
			'_menu_item_object_id' => 'e3tXUF9QT1NUX0xpZmVzdHlsZX19',
			'_menu_item_object' => 'cGFnZQ=='
		)
	); 




Widgety
--------------



OLD @TODO - 

1. Zkopírovat z databáze wp_options řádek `sidebars_widgets` (ignorovat wp_inactive_widgets orphaned_widgets_1 a orphaned_widgets_2)
Vložit do demoX.php `$jaw_demo_content['options'][]`
 
2. Zkopírovat z databáze wp_options řádky `widget_XXX`
Vložit do demoX.php `$jaw_demo_content['options'][]`