Custom styles
=============

Dear customers, into this folder you can upload your stylesheets.
All files with .less extension will be compiled and used on frontend.

- Put some .less files into this folder (e.g. custom_style.less)
- Insert into that file css or less code
- Re-Save Theme Options!

Then will be your code compiled with other custom styles (some colors, font sizes, ...) 
and will be saved in /css/themeoptions-1.css file


!!! Notice:
-----------
- Don't forget use for for @import or font URLs in your custom code "./custom_styles/" folder.
- Use only files with .less extension







How to insert Custom Fonts
-----------------------

If you want to link new custom font, so please upload your 

- my-font.ttf
- my-font.eot
- my-font.woff
- my-font.svg 

files into this folder, and then create new css stylesheet with this content:

     @font-face {
	font-family: 'my-font';
	src:url('./custom_styles/my-font.eot');
	src:url('./custom_styles/my-font.eot') format('embedded-opentype'),
		url('./custom_styles/my-font.woff') format('woff'),
		url('./custom_styles/my-font.ttf') format('truetype'),
		url('./custom_styles/my-font.svg') format('svg');
	font-weight: normal;
	font-style: normal;
     }

in Theme options As font face set "my-font"
