<?php
if (jwOpt::get_option('fbcomments_switch', '0') == '0') {
    $guestion = jwOpt::get_option('comments_antispam_question');
    ?>
    <div class="post-comments row">
        <?php
        if (!function_exists('jw_comment')) {

            function jw_comment($comment, $args, $depth) {
                $GLOBALS['comment'] = $comment;
                switch ($comment->comment_type) :
                    case 'pingback' :
                    case 'trackback' :
                        ?>
                        <li class="post pingback">
                            <p><?php esc_html_e('Pingback:', "gdn-theme"); ?> <?php comment_author_link(); ?><?php edit_comment_link(esc_html__('Edit', "gdn-theme"), '<span class="edit-link">', '</span>'); ?></p>
                            <?php
                            break;
                        default :
                            ?>
                        <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
                            <div class="one-comment-item">
                                <div class="author-avatar">
                                    <div class="comment-author vcard">
                                        <?php
                                        $commentID = get_comment_ID();
                                        $getComment = get_comment($commentID);
                                        $avatar_size = 68;
                                        if ('0' != $comment->comment_parent)
                                            $avatar_size = 68;
                                            ?>
                                            <a href="<?php echo get_author_posts_url($getComment->user_id); ?>"><?php echo get_avatar($comment,$avatar_size); ?></a>
                                            <?php
                                        ?>
                                    </div><!-- .comment-author .vcard -->
                                    <div class="comment-servise-link">
                                        <?php comment_reply_link(array_merge($args, array('reply_text' => '<i class="jaw-icon-reply"></i>' . esc_html__('reply', "gdn-theme"), 'depth' => $depth, 'max_depth' => $args['max_depth'], 'login_text' => '<i class="jaw-icon-reply"></i>' . esc_html__('log in to reply', "gdn-theme") ))); ?>
                                        <?php edit_comment_link('<i class="jaw-icon-pencil2"></i>' . esc_html__('edit', "gdn-theme"), '<span class="edit-link">', '</span>'); ?>
                                    </div>  
                                </div> 

                                <div id="comment-<?php comment_ID(); ?>" class="row comment comment-item">
                                    <div class="comment-item-content">
                                        <?php if ($comment->comment_approved == '0') : ?>
                                            <footer class="comment-meta">
                                                <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', "gdn-theme"); ?></em>
                                                <br />
                                            </footer>
                                        <?php endif; ?>

                                        <div class="meta-comment">
                                            <div class="meta_first_line">
                                                <?php
                                                $commentID = get_comment_ID();
                                                $getComment = get_comment($commentID);
                                                ?>
                                                <span class="author-name">
                                                <?php if($getComment->user_id > 0){ ?>
                                                    <a href="<?php echo get_author_posts_url($getComment->user_id); ?>" class='url'>
                                                <?php } ?>
                                                    <?php echo get_comment_author_link(); ?>
                                                <?php if($getComment->user_id > 0){ ?>
                                                    </a>
                                                <?php } ?>
                                                </span>
                                                <a class="comment-item-date" href="<?php echo esc_url(get_comment_link($comment->comment_ID)) ?>"><?php echo comment_date(get_option( 'date_format' ),$comment->comment_ID) . " at " . get_comment_time() ?>
                                                </a>
                                            </div>
                                        </div>
                                        <div class="comment-content">
                                            <?php comment_text(); ?>
                                        </div>
                                    </div>
                                    <div class="clear"></div>
                                </div><!-- #comment-## -->
                                <div class="comment-nav-line"></div>
                            </div>
                            <?php
                            break;
                    endswitch;
                }

            }

            // Do not delete these lines
            if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
                die(esc_html__('Please do not load this page directly. Thanks!', "gdn-theme"));

            if (post_password_required()) {
                ?>
                <section id="comments" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="notice">
                        <p class="bottom"><?php esc_html_e('This post is password protected. Enter the password to view comments.', "gdn-theme"); ?></p>
                    </div>
                </section>
                <?php
                return;
            }
            ?>
            <?php // You can start editing here. Customize the respond form below   ?>
            <?php if (have_comments()) : ?>
                <section id="comments" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="comments-title <?php echo esc_attr(jaw_template_get_var('bar_type', '')); ?>">
                        <div class="section_wrapper">
                            <div class="section_bar">
                                <h3 class="section-name"><?php echo esc_html__('Comments', "gdn-theme"); ?> </h3>
                            </div>
                        </div>
                    <?php echo jaw_get_template_part('featured_discussion', 'blog'); ?>
                    </div>
                    <div class="row ">
                        <ol class="col-lg-12 col-md-12 col-sm-12 col-xs-12 commentlist">
                            <?php wp_list_comments(array('callback' => 'jw_comment')); ?>
                        </ol>
                    </div>
                    <footer>
                        <nav id="comments-nav">
                            <div class="comments-next"><?php next_comments_link('<i class="jaw-icon-arrow-circle-left-1px"></i> '.esc_html__('Newer comments', "gdn-theme")); ?></div>
                            <div class="comments-previous"><?php previous_comments_link(esc_html__('Older comments', "gdn-theme").' <i class="jaw-icon-arrow-circle-right-1px"></i>'); ?></div>
                            <div class="clear"></div>
                        </nav>
                    </footer>
                </section>
            <?php else : // this is displayed if there are no comments so far   ?>
                <?php if (comments_open()) : ?>
                <?php else : // comments are closed    ?>
                    <section id="comments">
                        <div class="notice">
                            <p class="bottom"><?php esc_html_e('Comments are closed.', "gdn-theme") ?></p>
                        </div>
                    </section>
                <?php endif; ?>
            <?php endif; ?>
            <?php
            if (!isset($comment_question)) {
                $comment_question = '';
            }


            $textarea_class = '';
            if (jwOpt::get_option('comments_antispam_toggle', '0') != '0') {
                $textarea_class = 'question-on';
            }

            $args = array(
                'id_form' => 'commentform',
                'id_submit' => 'submit',
                'title_reply' => '<span class="'.jaw_template_get_var('bar_type', '').' section_bar">'.esc_html__('Leave a Reply', "gdn-theme").'</span>',
                'title_reply_to' => esc_html__('Leave a Reply to', "gdn-theme") . ' %s',
                'label_submit' => esc_html__('Send', "gdn-theme"),
                'comment_field' => '<div ' . (is_user_logged_in() ? 'class="comment-bottom-hide"' : 'class="comment-bottom"') . '>
                                                <p >
                                                   <label>'.esc_html__("Your comment",'gdn-theme').'</label>
                                                    <textarea name="comment" class="' . $textarea_class . '" id="comment" tabindex="4"></textarea>
                                                </p><span class="jaw-antispam-ans" ><p style="display:' . ((jwOpt::get_option('comments_antispam_toggle', '0') == '0') ? 'none' : 'inherit' ) . '" >

                            <input type="text" class="five" name="question" id="question" value="' . esc_attr($comment_question) . '" size="22" tabindex="4" ' . ($req ? "aria-required='true'" : '') . ' placeholder="' . $guestion . '" >
                                                    </p></span>
                                                    <input name="submit" type="submit" id="submit" class="submit jw-submit" value="'.esc_html__('Send', "gdn-theme").'">
                                                    </div>',
                'must_log_in' => '<p>' . sprintf(esc_html__('You must be ', "gdn-theme") . '<a href="%s">' . esc_html__('logged in', "gdn-theme") . '</a> ' . esc_html__('to post a comment.', "gdn-theme"), wp_login_url(get_permalink())) . '</p>',
                'logged_in_as' => '<p>' . sprintf(esc_html__('Logged in as', "gdn-theme") . ' <a href="%s/wp-admin/profile.php">%s</a>.', get_option('siteurl'), $user_identity) . ' <a href="' . wp_logout_url(get_permalink()) . '" title="' . esc_html__('Log Out of this account', "gdn-theme") . '">' . esc_html__('Log Out &gt;', "gdn-theme") . '</a></p>',
                'comment_notes_before' => '',
                'comment_notes_after' => '',
                'fields' => apply_filters('comment_form_default_fields', array(
                    'author' => '<div class="comment-top">
                                                    <p >
                                                    <label>' . esc_html__('Your name', "gdn-theme") . '</label>
                                                     <input type="text" class="five" name="author" id="author" value="' . esc_attr($comment_author) . '" size="22" tabindex="1" ' . ($req ? "aria-required='true'" : '') . '"> </p>',
                    'email' => '<p >
                                                  <label>' . esc_html__('Your email', "gdn-theme") . '</label>
                                                    <input type="text" class="five" name="email" id="email" value="' . esc_attr($comment_author_email) . '" size="22" tabindex="2"  ' . ($req ? "aria-required='true'" : '') . '"> </p>',
                    'url' => '<p >
                                                    <label>' . esc_html__('Your website', "gdn-theme") . '</label>
                                                    <input type="text" class="five" name="url" id="url" value="' . esc_url($comment_author_url) . '" size="22" tabindex="3">
                                                    </p>
                                                    </div>'
            )));
            comment_form($args);
            ?>
    </div>
    <?php
} else {
    ?>
    <div  class="post-comments jw-fb-comments row">
        <section id="comments" class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <?php jwFacebook::get_fb_comment(); ?>
        </section>
    </div>
    <?php
}
