<?php
get_header();

$jaw_class = array();
$jaw_class[] = jwLayout::content_class();
$jaw_class[] = jwLayout::content_layout();
$jaw_class[] = 'jaw-attachment';
$jaw_class[] = 'content';
$jaw_class[] = 'jaw-single';
$singlepost_preset = "";
if ($jaw_page_color = get_post_meta(get_the_ID(), 'jaw_page_color', true)) {
    echo jwUtils::customizer_preview_preset("Page", $jaw_page_color);
    $jaw_class[] = $singlepost_preset = 'post-preset-' . $jaw_page_color . ' ';
} else {
    echo jwUtils::customizer_preview_preset("Page",jwOpt::get_option('main_color', 'default'));
    $jaw_class[] = $singlepost_preset = 'post-preset-' . jwOpt::get_option('main_color', 'default') . ' ';
}
?>
<div id="content" class="<?php echo esc_attr( implode(' ', $jaw_class)); ?>">
    <div class="post-box builder-section">
    <?php
    while (have_posts()) : the_post();
        ?>
        <article <?php post_class('content' . ' ' . jwLayout::col_class(12)); ?> id="post-<?php the_ID(); ?>">
            <div class="row entry-content">
                <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> ">
                    <div class="description-cover">
                        <header>
                            <h1 class="entry-title"><?php the_title(); ?></h1>
                        </header>
                        <div class="entry-description">
                            <?php the_content(); ?>
                        </div><!-- .entry-description -->
                        <?php
                        // META
                        ?>
                        <div class="row">
                            <ul class="<?php echo esc_attr(jwLayout::col_class(12)); ?> blog-meta-info-top blog-meta-info">
                                <li class="post-meta-date">
                                    <span class="date">
                                        <?php echo jwRender::get_meta_date(); ?>
                                    </span>
                                </li>
                                <?php if((jwRender::get_meta_image_size($post->ID))) { ?>
                                <li class="post-meta-size">
                                    <span class="size">
                                        <?php echo jwRender::get_meta_image_size($post->ID); ?>
                                    </span>
                                </li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="img-container image">
            <?php   
                echo jwMedia::getAttachment($post->ID, array('large','full'), false, array(false, 'full', jaw_template_get_counter('pagination')));
            ?>
            </div>
            <div class="row entry-caption">
                <div class="<?php echo esc_attr(jwLayout::col_class(12)); ?> ">
                    <?php the_excerpt(); ?>
                </div>
            </div>
    </article><!-- #post -->
<?php endwhile; // end of the loop.   ?>
    </div>
</div>

<?php get_sidebar(); ?>


<?php
get_footer();
